import java.awt.EventQueue;

import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

import java.awt.BorderLayout;

import javax.swing.JButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.Vector;


public class MainWindow {

	private JFrame frame;
	Vector <AddressEntry> addressEntryList = new Vector<AddressEntry>();
	JList <AddressEntry> addressEntryJList;
	DefaultListModel<AddressEntry> myaddressEntryListModel = new DefaultListModel<AddressEntry>();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		
		
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainWindow window = new MainWindow();
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainWindow() {
		
		//make a dummy addressEntryList with 2 AddressEntry objects
		addressEntryList.add(new AddressEntry(1,"Lynne", "Grewe", "33 A street", "Hayward", "CA", 9399,"l@csueastbay.edu","555-1212"));
		addressEntryList.add(new AddressEntry(2,"Jane", "Doe", "22 Cobble street", "Hayward", "CA", 9399,"jane@csueastbay.edu","555-9999"));
		
		//because we want to REMOVE or ADD to our JList we have to create it rather than directly
		//from the Vector from a DefaultListModel (see https://docs.oracle.com/javase/tutorial/uiswing/components/list.html)
		// to which we add the elements of our vector
		
		for(int i = 0; i<addressEntryList.size(); i++)
		{  this.myaddressEntryListModel.add(i, this.addressEntryList.elementAt(i)); }
		
		
		//Now when we create our JList do it from our ListModel rather than our vector of AddressEntry
		addressEntryJList = new JList<AddressEntry>(this.myaddressEntryListModel);
		
		// create JList using the addressEntryList
		this.addressEntryJList.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
		this.addressEntryJList.setLayoutOrientation(JList.HORIZONTAL_WRAP);
		this.addressEntryJList.setVisibleRowCount(-1);
		
		
		//setup GUI and use the JList we created
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frame = new JFrame();
		frame.setBounds(100, 100, 450, 300);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		//setup JList
		
		
		//create scrollPane associated with JList
		JScrollPane scrollPane = new JScrollPane(this.addressEntryJList);
		frame.getContentPane().add(scrollPane, BorderLayout.CENTER);
		
		JButton btnRemove = new JButton("Remove");
		btnRemove.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				int index = addressEntryJList.getSelectedIndex();
				if(index != -1)//something is selected otherwise do nothing
			    //retrieve the DeffaultListModel associated with our JList and remove from it the AddressEntry at this index
				((DefaultListModel<AddressEntry>) (addressEntryJList.getModel())).remove(index);
			}
		});
		scrollPane.setColumnHeaderView(btnRemove);
	}

}
